package examples.stateless.container;

import javax.ejb.EJB;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.http.HttpServlet;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import examples.stateless.interfaces.PricerInjection;
import examples.stateless.interfaces.PricerLookup;

/**
 * Servlet Class
 * 
 * @web.servlet name="PricerClient" display-name="Name for PricerClient"
 *              description="Description for PricerClient"
 * @web.servlet-mapping url-pattern="/PricerClient"
 * @web.servlet-init-param name="A parameter" value="A value"
 */
public class PricerClientServlet extends HttpServlet {
	@EJB PricerInjection pi2;
	@EJB PricerLookup pl2;

	
	protected void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {

		doPost(req, resp);
	}

	protected void doPost(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {
		
		double price = 85.0;
		String state = "ny";

		PrintWriter pw = resp.getWriter();
		resp.setContentType("text/html");
		pw.println("<HTML>\n\t<BODY>");
		
		try {
			InitialContext ic = new InitialContext();
			pw.println("<h3>Here are the JNDI names bound for beans in this example:</h3>");
			pw.println("<ol>");
			NamingEnumeration ne = ic.list("");
			while (ne.hasMore()) {
				NameClassPair ncp = (NameClassPair) ne.next();
				pw.println("<li>" + ncp.getName());
			}
			pw.println("</ol>");

			// Pricer pricer = (Pricer)ic.lookup(Pricer.class.getName());
			PricerInjection pi = (PricerInjection)ic.lookup("#"+PricerInjection.class.getName());
			PricerLookup pl = (PricerLookup)ic.lookup("#"+PricerLookup.class.getName());

			pw.println("Tax (using lookup) on: " + price + " for State: "
					+ state + " is: " + pl.getTaxLookup(price, state) + "<br>");

			pw.println("Tax (using injection) on: " + price + " for State: "
					+ state + " is: " + pi.getTaxInjection(price, state)
					+ "<br>");
			
			pw.println("Tax (using lookup from @EJB) on: " + price + " for State: "
					+ state + " is: " + pl2.getTaxLookup(price, state) + "<br>");

			pw.println("Tax (using injection @EJB) on: " + price + " for State: "
					+ state + " is: " + pi2.getTaxInjection(price, state)
					+ "<br>");
		} 
		catch (NamingException e) {
			e.printStackTrace();
		}

		pw.println("\t</BODY>\n</HTML>");
	}
}
